/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten.db;

import java.sql.SQLException;
import javax.sql.DataSource;
import luwa.marlin.importer.stammdaten.util.Umgebungsvariable;
import oracle.jdbc.pool.OracleDataSource;
import org.postgresql.ds.PGSimpleDataSource;

public class Datenbanken {
    public static DataSource pegeldatenDataSource() {
        return Datenbanken.createDataSource(Umgebungsvariable.mitFallback("MARLIN_PEGELDATEN_DB_URL", ""), Umgebungsvariable.mitFallback("MARLIN_PEGELDATEN_DB_USER", "pegeldaten"), Umgebungsvariable.mitFallback("MARLIN_PEGELDATEN_DB_PASSWORD", ""));
    }

    public static DataSource alteStammdatenLUNGDataSource() {
        return Datenbanken.createDataSource(Umgebungsvariable.mitFallback("MV_STAMMDATEN_DB_URL", ""), Umgebungsvariable.mitFallback("MV_STAMMDATEN_DB_USER", "postgres"), Umgebungsvariable.mitFallback("MV_STAMMDATEN_DB_PASSWORD", ""));
    }

    public static DataSource alteStammdatenBUKEADataSource() {
        return Datenbanken.createDataSource(Umgebungsvariable.mitFallback("BUKEA_STAMMDATEN_DB_URL", ""), Umgebungsvariable.mitFallback("BUKEA_STAMMDATEN_DB_USER", ""), Umgebungsvariable.mitFallback("BUKEA_STAMMDATEN_DB_PASSWORD", ""));
    }

    private static DataSource createDataSource(String url, String user, String password) {
        try {
            if (url.startsWith("jdbc:postgresql:")) {
                PGSimpleDataSource pgDataSource = new PGSimpleDataSource();
                pgDataSource.setURL(url);
                pgDataSource.setUser(user);
                pgDataSource.setPassword(password);
                return pgDataSource;
            }
            OracleDataSource oracleDataSource = new OracleDataSource();
            oracleDataSource.setURL(url);
            oracleDataSource.setUser(user);
            oracleDataSource.setPassword(password);
            return oracleDataSource;
        }
        catch (SQLException e) {
            System.out.println("Could not create datasource: " + e.getMessage());
            System.exit(-1);
            throw new InstantiationError("Could not create datasource: " + e.getMessage());
        }
    }
}

