/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import luwa.marlin.importer.stammdaten.Importer;
import luwa.marlin.importer.stammdaten.db.Datenbanken;
import luwa.marlin.importer.stammdaten.periphery.CSVLoader;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.ArbeitsplatzRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.GeneralRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.KerndatenRepository;
import luwa.marlin.importer.stammdaten.repository.stammdatenBUKEA.BukeaRepository;
import luwa.marlin.importer.stammdaten.repository.stammdatenBUKEA.BukeaSchl\u00fcssellistenRepository;
import luwa.marlin.importer.stammdaten.types.GWMessstelle;
import luwa.marlin.importer.stammdaten.types.OWMessstelle;
import luwa.marlin.importer.stammdaten.types.ParameterMessger\u00e4te;
import luwa.marlin.importer.stammdaten.util.ConnectionHandler;

public class MainBUKEA {
    public static void main(String[] args) throws SQLException, FileNotFoundException {
        try (Connection pegeldatenConnection = Datenbanken.pegeldatenDataSource().getConnection();
             Connection stammdatenBukeaConnection = Datenbanken.alteStammdatenBUKEADataSource().getConnection();){
            boolean isOracle = true;
            BukeaSchl\u00fcssellistenRepository schl\u00fcsslelistenRepository = new BukeaSchl\u00fcssellistenRepository(pegeldatenConnection);
            GeneralRepository generalRepository = new GeneralRepository(pegeldatenConnection, true);
            KerndatenRepository kerndatenRepository = new KerndatenRepository(pegeldatenConnection, generalRepository, schl\u00fcsslelistenRepository, true);
            ArbeitsplatzRepository arbeitsplatzRepository = new ArbeitsplatzRepository(pegeldatenConnection, generalRepository, schl\u00fcsslelistenRepository, true);
            CSVLoader loader = new CSVLoader();
            List<GWMessstelle> gw = loader.lesenAus(MainBUKEA.getFile("Zu_migrierende_Messstellen_GW.csv"), GWMessstelle.class);
            List<OWMessstelle> ow = loader.lesenAus(MainBUKEA.getFile("Zu_migrierende_Messstellen_OW.csv"), OWMessstelle.class);
            List<ParameterMessger\u00e4te> parameter = loader.lesenAus(MainBUKEA.getFile("Parameter_Messgeraete.csv"), ParameterMessger\u00e4te.class);
            BukeaRepository ladeRepository = new BukeaRepository(new ConnectionHandler(stammdatenBukeaConnection), gw, ow, parameter);
            Importer importer = new Importer(generalRepository, kerndatenRepository, arbeitsplatzRepository, ladeRepository);
            importer.importStammdaten();
        }
    }

    public static File getFile(String fileName) throws FileNotFoundException {
        File jarFile = new File(MainBUKEA.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        File jarDir = jarFile.getParentFile();
        File externalFile = new File(jarDir, fileName);
        if (externalFile.exists()) {
            return externalFile;
        }
        URL resource = MainBUKEA.class.getResource("/" + fileName);
        if (resource != null) {
            return new File(resource.getFile());
        }
        throw new FileNotFoundException("File not found: " + fileName);
    }
}

