/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.importer.stammdaten;

import java.util.List;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Alarme;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Aufgaben;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Beobachtung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Betriebspegel;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Bilder;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Festpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Funktion;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Geographie;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Hauptwerte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Logger;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.LoggerKommunikation;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Messger\u00e4t;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Nullpunkte;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Pegelbezeichnungen;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Referenz;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Rueckstau;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Status;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Verwaltung;
import luwa.marlin.importer.stammdaten.dom\u00e4ne.Vorg\u00e4nger;
import luwa.marlin.importer.stammdaten.repository.LadeRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.ArbeitsplatzRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.GeneralRepository;
import luwa.marlin.importer.stammdaten.repository.pegeldaten.KerndatenRepository;

public class Importer {
    private final GeneralRepository generalRepository;
    private final KerndatenRepository kerndatenRepository;
    private final ArbeitsplatzRepository arbeitsplatzRepository;
    private final LadeRepository ladeRepository;

    public Importer(GeneralRepository generalRepository, KerndatenRepository kerndatenRepository, ArbeitsplatzRepository arbeitsplatzRepository, LadeRepository ladeRepository) {
        this.generalRepository = generalRepository;
        this.kerndatenRepository = kerndatenRepository;
        this.arbeitsplatzRepository = arbeitsplatzRepository;
        this.ladeRepository = ladeRepository;
    }

    public void importStammdaten() {
        System.out.println("*** Import gestartet ***");
        this.generalRepository.deleteAllStammdaten();
        this.importMessstellen();
        this.importKerndaten();
        this.importArbeitsplatz();
        this.importBetriebspegel();
        this.refreshMaterializedViews();
        System.out.println("*** Import beendet ***");
    }

    private void importBetriebspegel() {
        System.out.println("* Import Betriebspegel *");
        Betriebspegel betriebspegel = this.generalRepository.ladeBetriebspegel();
        this.generalRepository.speichereMessstellen(betriebspegel.messstelle);
        this.kerndatenRepository.speicherePegelbezeichnungen(betriebspegel.pegelbezeichnung);
        this.kerndatenRepository.speichereStatus(betriebspegel.status);
        this.kerndatenRepository.speichereFunktion(betriebspegel.funktion);
    }

    private void refreshMaterializedViews() {
        this.generalRepository.refreshMaterializedViews();
    }

    private void importMessstellen() {
        List<Integer> messstellen = this.ladeRepository.ladeMessstellen();
        this.generalRepository.speichereMessstellen(messstellen);
    }

    private void importKerndaten() {
        this.importPegelbezeichnung();
        this.importStatus();
        this.importVerwaltung();
        this.importGeographie();
        this.importFunktion();
        this.importAufgaben();
        this.importPegelbau();
        this.importBeobachtung();
        this.importAlarme();
        this.importNullpunkte();
        this.importFestpunkte();
        this.importVorg\u00e4ngerhistorie();
        this.importBilder();
        this.importHauptwerteDurchluss();
        this.importHauptwerteWasserstand();
        this.importHochwasserWiederkehr();
    }

    private void importArbeitsplatz() {
        this.importLogger();
        this.importLoggerKommunikation();
        this.importMessgeraete();
        this.importMessgeraeteKommunikation();
        this.importReferenz();
        this.importSeilkrananlage();
        this.importPegelschau();
        this.importStandortqualit\u00e4t();
        this.importInspektionsfahr();
        this.importBeobachtungsblatt();
        this.importRelevanteWerte();
        this.importMassgeblicherGewaesserabschnitt();
        this.importProbealarme();
        this.importMassnahmen();
        this.importRueckstau();
    }

    private void importPegelbezeichnung() {
        List<Pegelbezeichnungen> pegelbezeichnungen = this.ladeRepository.ladePegelbezeichnungen();
        this.kerndatenRepository.speicherePegelbezeichnungen(pegelbezeichnungen);
    }

    private void importStatus() {
        List<Status> status = this.ladeRepository.ladeStatus();
        this.kerndatenRepository.speichereStatus(status);
    }

    private void importVerwaltung() {
        List<Verwaltung> verwaltungen = this.ladeRepository.ladeVerwaltungen();
        this.kerndatenRepository.speichereVerwaltungen(verwaltungen);
    }

    private void importGeographie() {
        List<Geographie> geographie = this.ladeRepository.ladeGeographie();
        this.kerndatenRepository.speichereGeographie(geographie);
    }

    private void importFunktion() {
        List<Funktion> funktion = this.ladeRepository.ladeFunktion();
        this.kerndatenRepository.speichereFunktion(funktion);
    }

    private void importAufgaben() {
        List<Aufgaben> aufgaben = this.ladeRepository.ladeAufgaben();
        this.kerndatenRepository.speichereAufgaben(aufgaben);
    }

    private void importPegelbau() {
    }

    private void importBeobachtung() {
        List<Beobachtung> beobachtung = this.ladeRepository.ladeBeobachtung();
        this.kerndatenRepository.speichereBeobachtung(beobachtung);
    }

    private void importAlarme() {
        List<Alarme> alarme = this.ladeRepository.ladeAlarme();
        this.kerndatenRepository.speichereAlarme(alarme);
    }

    private void importNullpunkte() {
        List<Nullpunkte> nullpunkte = this.ladeRepository.ladeNullpunkte();
        this.kerndatenRepository.speichereNullpunkte(nullpunkte);
    }

    private void importFestpunkte() {
        List<Festpunkte> festpunkte = this.ladeRepository.ladeFestpunkte();
        this.kerndatenRepository.speichereFestpunkte(festpunkte);
    }

    private void importVorg\u00e4ngerhistorie() {
        List<Vorg\u00e4nger> vorg\u00e4nger = this.ladeRepository.ladeVorg\u00e4nger();
        this.kerndatenRepository.speichereVorg\u00e4nger(vorg\u00e4nger);
        this.kerndatenRepository.speichereNachfolger(vorg\u00e4nger);
    }

    private void importBilder() {
        List<Bilder> bilder = this.ladeRepository.ladeBilder();
        this.generalRepository.speichereBilderOHYD(bilder);
    }

    private void importHochwasserWiederkehr() {
    }

    private void importHauptwerteWasserstand() {
        List<Hauptwerte> hauptwerte = this.ladeRepository.ladeHauptwerteW();
        this.kerndatenRepository.speichereHauptwerteW(hauptwerte);
    }

    private void importHauptwerteDurchluss() {
        List<Hauptwerte> hauptwerte = this.ladeRepository.ladeHauptwerteQ();
        this.kerndatenRepository.speichereHauptwerteQ(hauptwerte);
    }

    private void importLogger() {
        List<Logger> logger = this.ladeRepository.ladeLogger();
        this.arbeitsplatzRepository.speichereLogger(logger);
    }

    private void importLoggerKommunikation() {
        List<LoggerKommunikation> kommunikation = this.ladeRepository.ladeKommunikation();
        this.arbeitsplatzRepository.speichereKommunikation(kommunikation);
    }

    private void importMessgeraete() {
        List<Messger\u00e4t> messger\u00e4te = this.ladeRepository.ladeMessgeraet();
        this.arbeitsplatzRepository.speichereMessgeraet(messger\u00e4te);
    }

    private void importMessgeraeteKommunikation() {
    }

    private void importReferenz() {
        List<Referenz> referenz = this.ladeRepository.ladeReferenz();
        this.arbeitsplatzRepository.speichereReferenz(referenz);
    }

    private void importSeilkrananlage() {
    }

    private void importPegelschau() {
    }

    private void importStandortqualit\u00e4t() {
    }

    private void importInspektionsfahr() {
    }

    private void importBeobachtungsblatt() {
    }

    private void importRelevanteWerte() {
    }

    private void importMassgeblicherGewaesserabschnitt() {
    }

    private void importProbealarme() {
    }

    private void importMassnahmen() {
    }

    private void importRueckstau() {
        List<Rueckstau> rueckstau = this.ladeRepository.ladeRueckstau();
        this.arbeitsplatzRepository.speichereRueckstau(rueckstau);
    }
}

