#include <catch2/catch.hpp>
#include "schneide_base/Utility.hpp"

using namespace schneide;

TEST_CASE("split works")
{
  auto s = split("a;b", ';');
  REQUIRE(s.size() == 2);
}

TEST_CASE("empty string returns no elements")
{
  auto s = split("", ';');
  REQUIRE(s.empty());
}

TEST_CASE("split works with real world example :-)")
{
  auto s = split("ANNOUNCED;sealionz;2,1", ';');
  REQUIRE(s.size() == 3);
  REQUIRE(s.at(0) == "ANNOUNCED");
  REQUIRE(s.at(1) == "sealionz");
  REQUIRE(s.at(2) == "2,1");
}

TEST_CASE("split works with multiple delimiters")
{
  auto s = split("first\r\nsecond\nthird", {"\r\n", "\n"});
  REQUIRE(s == std::vector<std::string>{"first", "second", "third"});
}
