#include <catch2/catch.hpp>
#include "schneide_base/Interval.hpp"

using namespace schneide;
using namespace Catch::literals;

TEST_CASE("expands over integer range")
{
  auto range = Interval(3.0, 7.5).over(3);
  REQUIRE(range.fromRelative(0.0) == 3.0_a);
  REQUIRE(range.fromRelative(2.0) == 7.5_a);
}

TEST_CASE("relative work with negative ranges")
{
  auto range = Interval(5000.0, 1000.0);
  REQUIRE(range.fromRelative(0.5) == 3000.0);
}
