#include <catch2/catch.hpp>
#include "module_ftir/ParseSettings.hpp"

using namespace vera;

TEST_CASE("Parse apodization")
{
  REQUIRE(parseApodization("none")==APOD_NONE);
  REQUIRE(parseApodization("triangular")==APOD_TRIANGULAR);
  REQUIRE(parseApodization("happgenzel")==APOD_HAPPGENZEL);
  REQUIRE(parseApodization("bessel")==APOD_BESSEL);
  REQUIRE(parseApodization("hanning")==APOD_HANNING);
}

TEST_CASE("Parse offset correction type")
{
  REQUIRE(parseOffsetCorrectionType("none") == OT_NONE);
  REQUIRE(parseOffsetCorrectionType("all") == OT_ALL);
  REQUIRE(parseOffsetCorrectionType("ends") == OT_ENDS);
}

TEST_CASE("Parse zero filling factor")
{
  REQUIRE(parseZeroFillingFactor("none") == ZFF_NONE);
  REQUIRE(parseZeroFillingFactor("2") == ZFF_2);
  REQUIRE(parseZeroFillingFactor("4") == ZFF_4);
  REQUIRE(parseZeroFillingFactor("8") == ZFF_8);
  REQUIRE(parseZeroFillingFactor("16") == ZFF_16);
}
