#pragma once
#include <functional>
#include "schneide_base/Vocabulary.hpp"

namespace vera
{
template <typename T>
class OneTimeFactory
{
public:
  OneTimeFactory(std::function<Ptr<T>()> factory) : mFactory(std::move(factory))
  {
  }

  Ptr<T> operator()()
  {
    if (!mInstance)
      mInstance = mFactory();
    return mInstance;
  }

private:
  std::function<Ptr<T>()> mFactory;
  Ptr<T> mInstance;
};
}  // namespace vera