#pragma once

#include "Configuration.hpp"
#include "Hardware.hpp"
#include "OneTimeFactory.hpp"
#include "schneide_base/SerialConnection.hpp"
#include "schneide_base/Vocabulary.hpp"

namespace vera
{
class HardwareFactory
{
public:
  explicit HardwareFactory(Ptr<Configuration> config)
  : mConfig(std::move(config))
  {
  }

  Hardware make() const;

private:
  using ArduinoFactory = OneTimeFactory<schneide::SerialConnection>;

  Ptr<Pump> makePump(ArduinoFactory& arduinoFactory) const;
  Ptr<Heater> makeHeater() const;
  Ptr<FTIR> makeFTIR() const;
  Ptr<Positioner> makePositioner(ArduinoFactory& arduinoFactory) const;

  Configuration& config() const
  {
    return *mConfig;
  }
  Ptr<Configuration> mConfig;
};
}
