#pragma once

#include "module_ftir/FTIR.hpp"
#include "module_heater/Heater.hpp"
#include "module_positioner/Positioner.hpp"
#include "module_pump/Pump.hpp"
#include "schneide_base/Vocabulary.hpp"

namespace vera
{
class Hardware
{
public:
  Hardware(Ptr<Heater> heater, Ptr<Positioner> positioner, Ptr<Pump> pump,
    Ptr<FTIR> ftir);

  Ptr<Heater> heater() const
  {
    return mHeater;
  }
  Ptr<Positioner> positioner() const
  {
    return mPositioner;
  }
  Ptr<Pump> pump() const
  {
    return mPump;
  }
  Ptr<FTIR> ftir() const
  {
    return mFTIR;
  }

private:
  Ptr<Heater> mHeater;
  Ptr<Positioner> mPositioner;
  Ptr<Pump> mPump;
  Ptr<FTIR> mFTIR;
};
}
