#pragma once

#include <chrono>
#include <string>
#include "schneide_base/INIReader.hpp"
#include "module_ftir/FTIRConfiguration.hpp"

namespace vera
{
using Duration = std::chrono::duration<double>;


class GeneralConfiguration
{
public:
  explicit GeneralConfiguration(schneide::ini::Section section)
  : mSection(std::move(section))
  {
  }

  std::string calibrationFile() const;

  double peakPosition() const;
  double smoothing() const;
  double peakSearchWidth() const;
  double peakIsolation() const;

  bool useBaseLine() const;

  std::string arduinoComPort() const;

  bool repeatAutomatically() const;
  Duration repeatWait() const;

private:
  schneide::ini::Section mSection;
};

class PositionerConfiguration
{
public:
  explicit PositionerConfiguration(schneide::ini::Section section)
  : mSection(std::move(section))
  {
  }

  std::string mode() const;
  int measurementPosition() const;
  int loadingPosition() const;
  Duration waitTime() const;

private:
  schneide::ini::Section mSection;
};

class PumpConfiguration
{
public:
  explicit PumpConfiguration(schneide::ini::Section section)
  : mSection(std::move(section))
  {
  }

  std::string mode() const;
  /** Time to release a drop for a single measurement.
   */
  Duration sampleTime() const;

  /** Time  to wait after releasing the drop and waiting for it to evaporate.
  */
  Duration evaporationTime() const;

  Duration loadTime() const;
  Duration unloadTime() const;

private:
  schneide::ini::Section mSection;
};

class HeaterConfiguration
{
public:
  explicit HeaterConfiguration(schneide::ini::Section section);
  
  std::string mode() const;
  std::string rampFile() const;
  std::string COMPort() const;
  int TDKAddress() const;
  Duration preHeatTime() const;
  std::string networkAddress() const;
  std::string networkPort() const;

private:
  schneide::ini::Section mSection;
};

class Configuration
{
public:
  explicit Configuration(std::string filename);


  FTIRConfiguration ftir() const;
  GeneralConfiguration general() const;
  PositionerConfiguration positioner() const;
  PumpConfiguration pump() const;
  HeaterConfiguration heater() const;

private:
  schneide::ini::Reader mReader;
};

}  // namespace vera
