#pragma once
#include <vector>
#include <string>

namespace vera
{
class ConcentrationCalibration
{
public:
  static ConcentrationCalibration fromFile(std::string const& fileName);

  ConcentrationCalibration(std::vector<double> ppm, std::vector<double> intensity);

  double findPPM(double intensity) const;
private:
  std::vector<double> mPpm;
  std::vector<double> mIntensity;
};
}

