#include "schneide_base/CSVReader.hpp"
#include "schneide_base/Numerical.hpp"
#include "ConcentrationCalibration.hpp"

using namespace vera;
using namespace schneide;

ConcentrationCalibration ConcentrationCalibration::fromFile(
  std::string const& fileName)
{
  std::vector<double> ppms;
  std::vector<double> intensities;

  auto parsed = CSVReader::parseFile(fileName);
  for (auto const& line : parsed)
  {
    auto ppm = line.at(0).asDouble();
    auto intensity = line.at(1).asDouble();

    ppms.push_back(ppm);
    intensities.push_back(intensity);
  }

  return ConcentrationCalibration(std::move(ppms), std::move(intensities));
}

ConcentrationCalibration::ConcentrationCalibration(
  std::vector<double> ppm, std::vector<double> intensity)
: mPpm(std::move(ppm)), mIntensity(std::move(intensity))
{
}

double ConcentrationCalibration::findPPM(double intensity) const
{
  auto relative = findRelative(mIntensity, intensity);
  return interpolate(mPpm, relative);
}
