#pragma once

#include <spdlog/fmt/fmt.h>
#include <chrono>
#include <string>
#include <vector>

namespace vera
{
class Interactor
{
public:
  Interactor();

  Interactor(Interactor const&) = delete;
  Interactor& operator=(Interactor const&) = delete;

  std::string question(
    std::string const& what, std::vector<std::string> const& options);
  void say(std::string const& what);

  void wait(std::chrono::duration<double> time);

  template <typename... Args>
  void say(std::string const& s, Args... args)
  {
    say(fmt::format(s, std::forward<Args>(args)...));
  }

private:
  std::string getAnswer(std::vector<std::string> const& options);
};

}  // namespace vera
