#pragma once
#include <string>

namespace schneide
{
class TextualValue
{
public:
  TextualValue() = default;

  explicit TextualValue(std::string content) : mContent(std::move(content))
  {
  }

  std::string const& asString() const
  {
    return mContent;
  }

  std::string const& asStringOr(std::string const& defaultValue) const
  {
    if (mContent.empty())
      return defaultValue;
    return asString();
  }

  double asDouble() const;

  double asDoubleOr(double defaultValue) const
  {
    if (mContent.empty())
      return defaultValue;
    return asDouble();
  }

  int asInteger() const;

  int asIntegerOr(int defaultValue) const
  {
    if (mContent.empty())
      return defaultValue;
    return asInteger();
  }

  bool asBool() const;

  bool asBoolOr(bool defaultValue) const
  {
    if (mContent.empty())
      return defaultValue;
    return asBool();
  }

private:
  std::string mContent;
};

inline bool operator==(TextualValue const& lhs, TextualValue const& rhs)
{
  return lhs.asString() == rhs.asString();
}

}  // namespace schneide
