#pragma once
#include <asio.hpp>
#include <string>

#include <spdlog/fmt/fmt.h>

namespace schneide
{
class SerialConnection
{
public:
  SerialConnection(
    std::string const& deviceName, std::string portName, char lineTerminator);

  std::string query(std::string message);

  template <typename... Args>
  std::string query(std::string format, Args... args)
  {
    return query(fmt::format(format, std::forward<Args>(args)...));
  }

private:
  void send(std::string const& message);

  std::string receive();

  std::string mPortName;
  char mLineTerminator;
  asio::io_service mIoService;
  asio::serial_port mPort;
};
}  // namespace schneide
