#pragma once
#include <vector>

namespace schneide
{
std::vector<double> convolve(
  std::vector<double> const& data, std::vector<double> const& kernel);
std::vector<double> gauss(std::vector<double> const& data, double sigma);
double interpolate(std::vector<double> const& data, double x);

/** Return a relative index into an ascending sequence.
    I.e. this is an inverse of the interpolation function for ascending values
*/
double findRelative(std::vector<double> const& ascendingValues, double which);
}  // namespace schneide
