#pragma once
#include "Interval.hpp"

namespace schneide
{
class Line
{
public:
  Line(Interval x, Interval y) : mX(x), mY(y)
  {
  }

  Line withRange(Interval newX)
  {
    return {newX, {at(newX.min), at(newX.max)}};
  }

  double at(double x) const
  {
    return mY.fromRelative(mX.toRelative(x));
  }

  double operator()(double x) const
  {
    return at(x);
  }

  Interval const& x() const
  {
    return mX;
  }

  Interval const& y() const
  {
    return mY;
  }

private:
  Interval mX;
  Interval mY;
};
}  // namespace schneide
