#pragma once

#include <string>
#include <vector>
#include "TextualValue.hpp"

namespace schneide
{
namespace CSVReader
{
using Value = TextualValue;

using Line = std::vector<Value>;
using File = std::vector<Line>;

File parseFile(std::string const& filename, char delimiter = ',');
File parseString(std::string const& content, char delimiter = ',');

std::vector<Value> valuesFor(std::vector<std::string> strings);

inline bool operator==(Value const& lhs, Value const& rhs)
{
  return lhs.asString() == rhs.asString();
}
}  // namespace CSVReader
}  // namespace schneide
