#include "ManualPump.hpp"

using namespace vera;

using namespace std::string_literals;

namespace
{
const auto PROCEED = "proceed"s;
const auto ABORT = "abort"s;
}

void ManualPump::dropSample(Interactor& interactor)
{
  auto answer = interactor.question(
    "Please apply the sample to the chip now, then proceed.", {PROCEED, ABORT});

  if (answer != PROCEED)
    throw std::runtime_error("Experiment aborted.");
}

void ManualPump::loadUp(Interactor & interactor)
{
  // Not needed!
}

void ManualPump::dump(Interactor & interactor)
{
  // Not needed!
}
