#pragma once
#include "Pump.hpp"
#include "schneide_base/SerialConnection.hpp"
#include "schneide_base/Vocabulary.hpp"

namespace vera
{
class ArduinoPump : public Pump
{
public:
  using Duration = std::chrono::duration<double>;
  ArduinoPump(Ptr<schneide::SerialConnection> terminal, Duration loadTime,
    Duration sampleTime, Duration evaporationTime, Duration unloadTime);

  // Inherited via Pump
  void dropSample(Interactor& interactor) override;

  // Inherited via Pump
  void loadUp(Interactor& interactor) override;
  void dump(Interactor& interactor) override;

private:
  void runFor(Interactor& interactor, Duration time);

  Ptr<schneide::SerialConnection> mTerminal;
  Duration mLoadTime;
  Duration mSampleTime;
  Duration mEvaporationTime;
  Duration mUnloadTime;
};
}  // namespace vera
