#include "ArduinoPump.hpp"

using namespace vera;

ArduinoPump::ArduinoPump(Ptr<schneide::SerialConnection> terminal, Duration loadTime, Duration sampleTime, Duration evaporationTime, Duration unloadTime)
: mTerminal(std::move(terminal)), mLoadTime(loadTime), mSampleTime(sampleTime), mEvaporationTime(evaporationTime), mUnloadTime(unloadTime)
{
}

void ArduinoPump::dropSample(Interactor& interactor)
{
  runFor(interactor, mSampleTime);
  interactor.say("Waiting for sample liquid to evaporate...");
  interactor.wait(mEvaporationTime);
  interactor.say("Done waiting.");
}

void ArduinoPump::loadUp(Interactor & interactor)
{
  runFor(interactor, mLoadTime);
}

void ArduinoPump::dump(Interactor & interactor)
{
  runFor(interactor, mUnloadTime);
}

void ArduinoPump::runFor(Interactor & interactor, Duration time)
{
  if (time.count() == 0.0)
    return;

  mTerminal->query("PUMP 1");
  interactor.wait(time);
  mTerminal->query("PUMP 0");
}
