#include "ManualPositioner.hpp"
#include <string>

using namespace vera;
using namespace std::string_literals;

namespace
{
const auto PROCEED = "proceed"s;
const auto ABORT = "abort"s;
}

void ManualPositioner::measurementPosition(Interactor & interactor)
{
  moveTo(interactor, "measurement");
}

void ManualPositioner::loadingPosition(Interactor & interactor)
{
  moveTo(interactor, "loading");
}

void ManualPositioner::moveTo(Interactor& interactor, std::string const& positionName) const
{
  auto answer = interactor.question(
    fmt::format("Please move the chip into --{0}-- position, then proceed.", positionName), {PROCEED, ABORT});

  if (answer != PROCEED)
    throw std::runtime_error("Experiment aborted.");
}

