#pragma once
#include "Positioner.hpp"
#include "schneide_base/SerialConnection.hpp"
#include "schneide_base/Vocabulary.hpp"

namespace vera
{
class ArduinoPositioner : public Positioner
{
public:
  ArduinoPositioner(Ptr<schneide::SerialConnection> terminal, int measurementPosition, int loadingPosition, std::chrono::duration<double> waitTime);

  // Inherited via Positioner
  void measurementPosition(Interactor& interactor) override;
  void loadingPosition(Interactor& interactor) override;

private:
  void moveMotor(Interactor& interactor, int where);

  Ptr<schneide::SerialConnection> mTerminal;
  int mMeasurementPosition;
  int mLoadingPosition;
  std::chrono::duration<double> mWaitTime;
};
}  // namespace vera