#pragma once
#include "AmpereControl.hpp"
#include "schneide_base/SerialConnection.hpp"

namespace vera
{
  
class TDKLambdaAmpereControl : public AmpereControl
{
public:
  using Duration = std::chrono::duration<double>;

  TDKLambdaAmpereControl(std::string const& comPort, int address);

  void start(Interactor& interactor) override;
  void stop(Interactor& interactor) override;
  void setAmpere(Interactor& interactor, double ampere) override;

private:
  std::string query(std::string request);
  int mAddress; // TDK-Lambda internal address
  schneide::SerialConnection mTerminal;
};
}