#include "TDKLambdaAmpereControl.hpp"
#include "schneide_base/CSVReader.hpp"
#include "schneide_base/Logger.hpp"

using namespace vera;
using namespace schneide;


TDKLambdaAmpereControl::TDKLambdaAmpereControl(std::string const& comPort, int address)
: mTerminal("TDK-Lambda", comPort, '\r'), mAddress(address)
{
}

std::string TDKLambdaAmpereControl::query(std::string request)
{
  return mTerminal.query(std::move(request));
}

void TDKLambdaAmpereControl::setAmpere(Interactor& interactor, double ampere)
{
  // Set new current
  query(fmt::format("PC {0:.2f}", ampere));

  // Get the current state of the device
  query("DVC?");
}

void TDKLambdaAmpereControl::start(Interactor& interactor)
{
  query(fmt::format("ADR {0}", mAddress));  // Address the device
  query("IDN?");

  query("OUT 1");  // Enable output
}

void TDKLambdaAmpereControl::stop(Interactor& interactor)
{
  // nothing to do!
}
