#pragma once
#include "AmpereControl.hpp"
#include <asio.hpp>
#include <string>

namespace vera 
{
class PS3000CAmpereControl : public AmpereControl
{
public:
  PS3000CAmpereControl(std::string const& address, std::string const& port);
  ~PS3000CAmpereControl();

  void start(Interactor& interactor);
  void stop(Interactor& interactor);
  void setAmpere(Interactor& interactor, double ampere) override;

private:
  void send(std::string const& message);
  std::string receive();
  std::string query(Interactor& interactor, std::string message);
  void command(Interactor& interactor, std::string message);

  asio::io_service mService;
  asio::ip::tcp::socket mSocket;
};
}
