#pragma once
#include <string>
#include "schneide_base/SerialConnection.hpp"
#include "Heater.hpp"
#include "vera_framework/Configuration.hpp"
#include "AmpereControl.hpp"

namespace vera
{
class AmpereControllingHeater : public Heater
{
public:
  using Duration = std::chrono::duration<double>;

  explicit AmpereControllingHeater(std::unique_ptr<AmpereControl> Control, HeaterConfiguration const& config);
  AmpereControllingHeater(std::unique_ptr<AmpereControl> Control, std::string const& rampFile, Duration preHeat);
  void prepare(Interactor& interactor) override;
  void burnClean(Interactor& interactor) override;
  void shutdown(Interactor& interactor) override;

private:
  using Clock = std::chrono::high_resolution_clock;
  
  void setAmpere(Interactor& interactor, double ampere);
  std::vector<std::pair<double, Duration>> mAmpereAndHoldTime;
  Duration mPreHeat;
  
  std::unique_ptr<AmpereControl> mControl;
};
}
