#include "ParseSettings.hpp"
#include <spdlog/fmt/fmt.h>
#include "schneide_base/Utility.hpp"

using namespace vera;
using namespace schneide;

APODTYPE vera::parseApodization(std::string rhs)
{
  rhs = toLower(std::move(rhs));
  if (rhs == "none")
    return APOD_NONE;
  if (rhs == "triangular")
    return APOD_TRIANGULAR;
  if (rhs == "happgenzel")
    return APOD_HAPPGENZEL;
  if (rhs == "bessel")
    return APOD_BESSEL;
  if (rhs == "hanning")
    return APOD_HANNING;

  throw std::invalid_argument(
    fmt::format("Invalid apodization setting: {0}", rhs));
}

OFFSETCORRECTTYPE vera::parseOffsetCorrectionType(std::string rhs)
{
  rhs = toLower(std::move(rhs));
  if (rhs == "none")
    return OT_NONE;
  if (rhs == "all")
    return OT_ALL;
  if (rhs == "ends")
    return OT_ENDS;

  throw std::invalid_argument(
    fmt::format("Invalid offset correction type: {0}", rhs));
}

ZFFTYPE vera::parseZeroFillingFactor(std::string rhs)
{
  rhs = toLower(std::move(rhs));
  if (rhs == "none")
    return ZFF_NONE;
  if (rhs == "2")
    return ZFF_2;
  if (rhs == "4")
    return ZFF_4;
  if (rhs == "8")
    return ZFF_8;
  if (rhs == "16")
    return ZFF_16;

  throw std::invalid_argument(
    fmt::format("Invalid zero filling factor setting: {0}", rhs));
}
