#pragma once
#include "schneide_base/INIReader.hpp"

namespace vera
{
class FTIRConfiguration
{
public:
  explicit FTIRConfiguration(schneide::ini::Section section)
  : mSection(std::move(section))
  {
  }

  std::string mode() const;
  int numberOfScans() const;
  double from() const;
  double to() const;
  int resolution() const;

  int backgroundNumberOfScans() const;
  bool recordSpectrums() const;

  int phasePoints() const;
  std::string const& phaseApodization() const;
  std::string const& interferogramApodization() const;
  std::string const& zeroFillingFactor() const;
  std::string const& offsetCorrectionType() const;

private:
  schneide::ini::Section mSection;
};
}  // namespace vera
