#include "FTIRConfiguration.hpp"

using namespace vera;

std::string FTIRConfiguration::mode() const
{
  return mSection["mode"].asStringOr("emulated");
}

int FTIRConfiguration::numberOfScans() const
{
  return mSection["number.of.scans"].asIntegerOr(128);
}

double FTIRConfiguration::from() const
{
  return mSection["from[wn]"].asDoubleOr(4000.0);
}

double FTIRConfiguration::to() const
{
  return mSection["to[wn]"].asDoubleOr(400.0);
}

int FTIRConfiguration::resolution() const
{
  return mSection["resolution[wn]"].asIntegerOr(8);
}

int FTIRConfiguration::backgroundNumberOfScans() const
{
  return mSection["background.number.of.scans"].asIntegerOr(1);
}

bool FTIRConfiguration::recordSpectrums() const
{
  return mSection["record.spectrums"].asBoolOr(true);
}

int vera::FTIRConfiguration::phasePoints() const
{
  return mSection["phase.points"].asIntegerOr(128);
}

std::string const& vera::FTIRConfiguration::phaseApodization() const
{
  return mSection["phase.apodization"].asStringOr("none");
}

std::string const& vera::FTIRConfiguration::interferogramApodization() const
{
  return mSection["interferogram.apodization"].asStringOr("none");
}

std::string const& vera::FTIRConfiguration::zeroFillingFactor() const
{
  return mSection["zero.filling.factor"].asStringOr("none");
}

std::string const& vera::FTIRConfiguration::offsetCorrectionType() const
{
  return mSection["offset.correction.type"].asStringOr("none");
}
