#include <thread>
#include "EmulatedFTIR.hpp"
#include "vera_base/Interactor.hpp"

namespace
{
constexpr auto DEFAULT_SPECTRUM_SIZE = 967;
constexpr auto DEFAULT_SPECTRUM_VALUE = 1.0;
}  // namespace

Ptr<vera::Spectrum> vera::EmulatedFTIR::scan(Interactor& interactor)
{
  interactor.say("Scanning spectrum...");
  return std::make_shared<Spectrum>(
    Interval(4000.0, 400.0), std::vector<double>(DEFAULT_SPECTRUM_SIZE, DEFAULT_SPECTRUM_VALUE));
}
