#pragma once
#include "FTIR.hpp"
#include <FTIRInst.h>
#include "FTIRConfiguration.hpp"

namespace vera
{
class AgilentFTIR : public FTIR
{
public:
  AgilentFTIR(FTIRConfiguration const& config);
  AgilentFTIR(int numberOfScans, double from, double to, int resolution, bool recordSpectrums, int spectrumBackgroundScans,
    int phasePoints, APODTYPE phaseApodization, APODTYPE interferogramApodization, ZFFTYPE zff, OFFSETCORRECTTYPE offset);
  AgilentFTIR(AgilentFTIR const&) = delete;
  ~AgilentFTIR();

  AgilentFTIR& operator=(AgilentFTIR const&) = delete;

  // Inherited via FTIR
  void prepare(Interactor& interactor) override;
  Ptr<vera::Spectrum> scan(Interactor& interactor) override;

private:
  void calibrate(Interactor& interactor);

  int mNumberOfScans;
  double mFrom;
  double mTo;
  int mResolution;
  bool mRecordSpectrums;
  int mSpectrumBackgroundScans;
};
}