#include <stdexcept>

#include <iostream>
#include <asio.hpp>
#include <spdlog/spdlog.h>

#include <spdlog/sinks/stdout_color_sinks.h>
#include <random>
#include "schneide_base/SerialConnection.hpp"

void run();

using tcp = asio::ip::tcp;

std::shared_ptr<spdlog::logger> const& logger()
{
  static std::shared_ptr<spdlog::logger> logger;
  if (!logger)
    logger = spdlog::stdout_color_mt("console");
  return logger;
}



void run()
{
  schneide::SerialConnection p("Arduino", "COM3", '\n');

  for (int i = 0; i < 5; ++i)
  {
    p.query("PUMP 1");
    std::this_thread::sleep_for(std::chrono::seconds(10));
    p.query("PUMP 0");
    /*std::this_thread::sleep_for(std::chrono::seconds(2));
    p.query("MOTOR 30");
    std::this_thread::sleep_for(std::chrono::seconds(2));
    p.query("MOTOR 130");*/
    std::this_thread::sleep_for(std::chrono::seconds(10));
  }
}


int main(int argc, char** argv)
{
  try
  {
    run();
    return 0;
  }
  catch (std::exception const& /*e*/)
  {
    return -1;
  }
}
