/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo.types;

import com.rewoo.external.rest.AutoReconnectableApiServices;
import com.rewoo.external.rest.exception.ScopeApiCallException;
import com.rewoo.external.rest.model.UserToken;
import com.schneide.rewoo.KFMBuilder;
import com.schneide.rewoo.type.Definition;
import com.schneide.rewoo.types.KFMConfig;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public interface KFMCreator {
    public int KFM_ENTRY_SIZE();

    public Logger logger();

    public List<Definition> definitions();

    public String getFileName();

    public Object getValue(Definition var1, Map<String, Object> var2, KFMConfig var3, int var4);

    default public void create(List<Map<String, Object>> buchungen, KFMConfig config, AutoReconnectableApiServices apiServices, UserToken userToken) {
        if (buchungen.isEmpty()) {
            return;
        }
        KFMBuilder builder = new KFMBuilder(this.KFM_ENTRY_SIZE(), buchungen.size());
        int i = 0;
        while (i < buchungen.size()) {
            Map<String, Object> booking = buchungen.get(i);
            int bookingIndex = i++;
            this.definitions().forEach(definition -> {
                Object value = this.getValue((Definition)definition, booking, config, bookingIndex);
                if (value == null) {
                    return;
                }
                builder.insert(bookingIndex, definition.offset(), definition.length(), value.toString(), definition.alignment());
            });
        }
        String fileName = this.getFileName();
        URL kfmFile = builder.buildFile(fileName);
        try {
            apiServices.saveFileByUrl(userToken, config.dateiUploadId(), config.dateiUploadFeldId(), kfmFile.toURI().toURL(), false);
        }
        catch (ScopeApiCallException | MalformedURLException | URISyntaxException e) {
            this.logger().warning(String.format("%s konnte nicht in Rewoo gespeichert werden", fileName));
        }
    }
}

