/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.schneide.rewoo.buchungen.BuchungenConfig;
import com.schneide.rewoo.konten.KontenConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public record AppConfig(BuchungenConfig buchungen, KontenConfig konten, String apiUrl, String agentUserName, String userName, String password) {
    public static AppConfig readConfig() throws IOException, URISyntaxException {
        Path jarPath = Paths.get(AppConfig.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        Path configPath = jarPath.resolve("config/config.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            throw new FileNotFoundException("Config file not found: " + String.valueOf(configPath));
        }
        InputStream configFile = Files.newInputStream(configPath, new OpenOption[0]);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(configFile, AppConfig.class);
    }
}

