/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo.konten;

import com.rewoo.external.rest.AutoReconnectableApiServices;
import com.rewoo.external.rest.model.EntryValueState;
import com.rewoo.external.rest.model.ScopeTableViewColumn;
import com.rewoo.external.rest.model.ScopeTableViewData;
import com.rewoo.external.rest.model.ScopeTableViewRow;
import com.rewoo.external.rest.model.ScopeValue;
import com.rewoo.external.rest.model.UserToken;
import com.schneide.rewoo.konten.KontenConfig;
import com.schneide.rewoo.konten.KontenKFM;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class KontenRepository {
    private final AutoReconnectableApiServices apiServices;
    private final UserToken userToken;
    private final KontenConfig config;
    private static final Logger logger = Logger.getLogger(KontenRepository.class.getName());

    public KontenRepository(AutoReconnectableApiServices apiServices, UserToken userToken, KontenConfig config) {
        this.apiServices = apiServices;
        this.userToken = userToken;
        this.config = config;
    }

    public void tagesabschluss() {
        ScopeTableViewData newAccounts = this.apiServices.getTableViewData(this.userToken, this.config.rewooTabelle(), "@neues_konto={true}", null, null);
        logger.info(String.format("Found %d new accounts", newAccounts.getRows().size()));
        Map<Long, String> idToColumn = newAccounts.getColumns().stream().collect(Collectors.toMap(column -> column.getEntry().getId(), ScopeTableViewColumn::getName));
        List<Map<String, Object>> accounts = newAccounts.getRows().stream().map(row -> row.getValues().stream().collect(Collectors.toMap(value -> (String)idToColumn.get(value.getEntryId()), ScopeValue::getValue))).toList();
        List<Long> elementIds = newAccounts.getRows().stream().map(ScopeTableViewRow::getElementId).toList();
        logger.info("Create account KFM file");
        KontenKFM kfm = new KontenKFM();
        kfm.create(accounts, this.config, this.apiServices, this.userToken);
        logger.info("Set account to not new");
        this.buche(elementIds);
    }

    private void buche(List<Long> elementIds) {
        for (Long elementId : elementIds) {
            this.apiServices.writeDatasheet(this.userToken, elementId, -1L, List.of(new ScopeValue(this.config.neuesKontoId(), false, EntryValueState.VALID, false, new Date())));
        }
    }
}

