/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo.konten;

import com.schneide.rewoo.type.Alignment;
import com.schneide.rewoo.type.Definition;
import com.schneide.rewoo.types.KFMConfig;
import com.schneide.rewoo.types.KFMCreator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class KontenKFM
implements KFMCreator {
    private static final int KFM_ENTRY_SIZE = 177;
    private final Logger logger = Logger.getLogger(KontenKFM.class.getName());
    private final List<Definition> definitions = List.of(new Definition(1, 8, "User", Alignment.LEFT), new Definition(9, 8, "DatumNeu", Alignment.LEFT), new Definition(17, 8, "DatumAend", Alignment.LEFT), new Definition(25, 8, "ZeitAend", Alignment.LEFT), new Definition(33, 6, "ProtokollNr", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(39, 3, "Satzart", Alignment.LEFT), new Definition(42, 28, "UkKey", Alignment.LEFT), new Definition(70, 1, "KzManuell", Alignment.LEFT), new Definition(71, 1, "KzDv", Alignment.LEFT), new Definition(72, 1, "KzVerd", Alignment.LEFT), new Definition(73, 1, "KzGesperrt", Alignment.LEFT), new Definition(74, 4, "HjBeginn", Alignment.LEFT), new Definition(78, 4, "HjEnde", Alignment.LEFT), new Definition(82, 8, "EndeDatum", Alignment.LEFT), new Definition(90, 25, "Text1", Alignment.LEFT), new Definition(115, 25, "Text2", Alignment.LEFT), new Definition(140, 4, "HHJahr1", Alignment.LEFT), new Definition(144, 5, "BW1", Alignment.LEFT), new Definition(149, 10, "HHVermerk1", Alignment.LEFT), new Definition(159, 4, "HHJahr2", Alignment.LEFT), new Definition(163, 5, "BW2", Alignment.LEFT), new Definition(168, 10, "HHVermerk2", Alignment.LEFT));

    @Override
    public int KFM_ENTRY_SIZE() {
        return 177;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public List<Definition> definitions() {
        return this.definitions;
    }

    @Override
    public String getFileName() {
        return String.format("K%s.txt", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    @Override
    public Object getValue(Definition definition, Map<String, Object> booking, KFMConfig config, int bookingIndex) {
        String key = definition.key();
        if (config.constants().containsKey(key)) {
            return config.constants().get(key);
        }
        switch (key) {
            case "ProtokollNr": {
                return bookingIndex + 1;
            }
            case "DatumNeu": 
            case "DatumAend": {
                LocalDateTime now = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                return now.format(formatter);
            }
            case "ZeitAend": {
                LocalDateTime now = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
                return now.format(formatter);
            }
        }
        return booking.get(config.fields().get(key));
    }
}

