/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo.buchungen;

import com.rewoo.external.rest.AutoReconnectableApiServices;
import com.rewoo.external.rest.model.EntryValueState;
import com.rewoo.external.rest.model.ScopeTableViewColumn;
import com.rewoo.external.rest.model.ScopeTableViewData;
import com.rewoo.external.rest.model.ScopeTableViewRow;
import com.rewoo.external.rest.model.ScopeValue;
import com.rewoo.external.rest.model.UserToken;
import com.schneide.rewoo.buchungen.BuchungenConfig;
import com.schneide.rewoo.buchungen.BuchungenKFM;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class BuchungenRepository {
    private final AutoReconnectableApiServices apiServices;
    private final UserToken userToken;
    private final BuchungenConfig config;
    private static final Logger logger = Logger.getLogger(BuchungenRepository.class.getName());

    public BuchungenRepository(AutoReconnectableApiServices apiServices, UserToken userToken, BuchungenConfig config) {
        this.apiServices = apiServices;
        this.userToken = userToken;
        this.config = config;
    }

    public void tagesabschluss() {
        ScopeTableViewData ungebucht = this.apiServices.getTableViewData(this.userToken, this.config.rewooTabelle(), "@Gebucht={false}", null, null);
        logger.info(String.format("Found %d bookings", ungebucht.getRows().size()));
        Map<Long, String> idToColumn = ungebucht.getColumns().stream().collect(Collectors.toMap(column -> column.getEntry().getId(), ScopeTableViewColumn::getName));
        List<Map<String, Object>> buchungen = ungebucht.getRows().stream().map(row -> row.getValues().stream().filter(value -> value.getValue() != null).collect(Collectors.toMap(value -> (String)idToColumn.get(value.getEntryId()), ScopeValue::getValue))).toList();
        List<Long> elementIds = ungebucht.getRows().stream().map(ScopeTableViewRow::getElementId).toList();
        logger.info("Create booking KFM file");
        BuchungenKFM kfm = new BuchungenKFM();
        kfm.create(buchungen, this.config, this.apiServices, this.userToken);
        logger.info("Set booking to booked and set booking date");
        this.buche(elementIds);
    }

    private void buche(List<Long> elementIds) {
        for (Long elementId : elementIds) {
            this.apiServices.writeDatasheet(this.userToken, elementId, -1L, List.of(new ScopeValue(this.config.gebuchtId(), true, EntryValueState.VALID, false, new Date()), new ScopeValue(this.config.datumId(), new Date(), EntryValueState.VALID, false, new Date())));
        }
    }
}

