/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo.buchungen;

import com.schneide.rewoo.type.Alignment;
import com.schneide.rewoo.type.Definition;
import com.schneide.rewoo.types.KFMConfig;
import com.schneide.rewoo.types.KFMCreator;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class BuchungenKFM
implements KFMCreator {
    private static final int KFM_ENTRY_SIZE = 908;
    private static final Logger logger = Logger.getLogger(BuchungenKFM.class.getName());
    private final List<Definition> definitions = List.of(new Definition(1, 3, "Verfahren", Alignment.LEFT), new Definition(4, 10, "Satzart", Alignment.LEFT), new Definition(14, 3, "BelegArt", Alignment.LEFT), new Definition(17, 1, "Aktion", Alignment.LEFT), new Definition(18, 8, "Datum", Alignment.LEFT), new Definition(26, 6, "Zeit", Alignment.LEFT), new Definition(32, 8, "Benutzer", Alignment.LEFT), new Definition(40, 4, "Erfassung_Nr", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(44, 2, "Status", Alignment.LEFT), new Definition(46, 6, "LkKg", Alignment.LEFT), new Definition(52, 4, "Haushaltjahr", Alignment.LEFT), new Definition(56, 4, "Rt", Alignment.LEFT), new Definition(60, 2, "Sb", Alignment.LEFT), new Definition(62, 4, "Gl", Alignment.LEFT), new Definition(66, 2, "Ob", Alignment.LEFT), new Definition(68, 4, "Gp", Alignment.LEFT), new Definition(72, 6, "Uk", Alignment.LEFT), new Definition(78, 20, "Kostenstelle", Alignment.LEFT), new Definition(98, 1, "Kostenstellen-PZ", Alignment.LEFT), new Definition(99, 20, "Kostentr\u00e4ger", Alignment.LEFT), new Definition(119, 8, "Leistungsdatum", Alignment.LEFT), new Definition(127, 6, "Dauervorgang", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(133, 10, "AbstimmNr", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(143, 10, "BelegReferenz", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(153, 2, "Zahlweg", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(155, 8, "Buchungsdatum", Alignment.LEFT), new Definition(163, 13, "Buchungsbetrag", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(176, 1, "Sammelbuchung", Alignment.LEFT), new Definition(177, 3, "Buchungsschl\u00fcssel", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(180, 27, "Buchungstext-1", Alignment.LEFT), new Definition(207, 27, "Buchungstext-2", Alignment.LEFT), new Definition(234, 20, "Beleg-Nr", Alignment.RIGHT), new Definition(254, 2, "Buchungsvermerk", Alignment.RIGHT), new Definition(256, 4, "Statistikschl\u00fcssel", Alignment.RIGHT), new Definition(260, 1, "Sammelzahlung", Alignment.LEFT), new Definition(261, 10, "Empf\u00e4ngerNr", Alignment.RIGHT_WITH_LEADING_ZEROS), new Definition(271, 50, "IBAN", Alignment.LEFT), new Definition(321, 11, "BIC", Alignment.LEFT), new Definition(332, 70, "Kontoinhaber", Alignment.LEFT), new Definition(402, 70, "Empf\u00e4ngerName", Alignment.LEFT), new Definition(472, 35, "Mandat", Alignment.LEFT), new Definition(507, 8, "Mandatsdatum", Alignment.LEFT), new Definition(515, 70, "Verwendungszweck-1", Alignment.LEFT), new Definition(585, 70, "Verwendungszweck-2", Alignment.LEFT), new Definition(655, 70, "Abweichender-Auftraggeber", Alignment.LEFT), new Definition(725, 8, "Rechnungsdatum", Alignment.LEFT), new Definition(733, 20, "Rechnungsnummer", Alignment.LEFT), new Definition(753, 16, "Kundennummer", Alignment.LEFT), new Definition(769, 8, "F\u00e4lligkeitsdatum", Alignment.LEFT), new Definition(777, 20, "Aktenzeichen", Alignment.LEFT), new Definition(797, 27, "Bemerkungen", Alignment.LEFT), new Definition(824, 27, "Projekt", Alignment.RIGHT), new Definition(851, 27, "Steuerkennzeichen", Alignment.LEFT), new Definition(878, 1, "Lastschriftart", Alignment.LEFT), new Definition(879, 3, "Vorgangsart", Alignment.LEFT), new Definition(882, 27, "Einzahler/Empf\u00e4nger", Alignment.LEFT));

    @Override
    public int KFM_ENTRY_SIZE() {
        return 908;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public List<Definition> definitions() {
        return this.definitions;
    }

    @Override
    public String getFileName() {
        return String.format("B%s.txt", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    @Override
    public Object getValue(Definition definition, Map<String, Object> booking, KFMConfig config, int bookingIndex) {
        String key = definition.key();
        if (config.constants().containsKey(key)) {
            return config.constants().get(key);
        }
        switch (key) {
            case "Erfassung_Nr": {
                return bookingIndex + 1;
            }
            case "Datum": {
                LocalDateTime now = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                return now.format(formatter);
            }
            case "Zeit": {
                LocalDateTime now = LocalDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
                return now.format(formatter);
            }
            case "Leistungsdatum": {
                Date date = (Date)booking.get(config.fields().get(key));
                return new SimpleDateFormat("yyyyMMdd").format(date);
            }
        }
        return booking.get(config.fields().get(key));
    }
}

