/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo;

import com.rewoo.external.rest.AutoReconnectableApiServices;
import com.rewoo.external.rest.model.UserToken;
import com.schneide.rewoo.buchungen.BuchungenRepository;
import com.schneide.rewoo.konten.KontenRepository;
import com.schneide.rewoo.types.AppConfig;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class Main {
    private static final int LOCK_PORT = 55555;
    private static final Logger logger = Logger.getLogger(Main.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try (ServerSocket socket = new ServerSocket(55555);){
            logger.info("Daily financial statement application started successfully!");
            logger.info("Try load config");
            AppConfig config = AppConfig.readConfig();
            logger.info("Connect to Rewoo Api");
            AutoReconnectableApiServices apiServices = new AutoReconnectableApiServices(config.apiUrl(), config.agentUserName());
            UserToken userToken = apiServices.login(config.userName(), config.password());
            try {
                logger.info("Start booking daily financial statement");
                BuchungenRepository buchungen = new BuchungenRepository(apiServices, userToken, config.buchungen());
                buchungen.tagesabschluss();
                logger.info("Start account daily financial statement");
                KontenRepository konten = new KontenRepository(apiServices, userToken, config.konten());
                konten.tagesabschluss();
            }
            finally {
                apiServices.logout(userToken);
            }
        }
        catch (IOException e) {
            logger.warning("Daily financial statement application is already running!");
            System.exit(1);
        }
        catch (URISyntaxException e) {
            logger.warning("Could not load config file: " + e.getMessage());
        }
    }
}

