/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.rewoo;

import com.schneide.rewoo.type.Alignment;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Logger;

public class KFMBuilder {
    private final char[] model;
    private final int entryCount;
    private final int singleSize;
    private final Logger logger = Logger.getLogger(KFMBuilder.class.getName());
    private final File kfmDir = new File(System.getProperty("java.io.tmpdir"), "kfm-files");

    public KFMBuilder(int size, int entryCount) {
        this.model = new char[size * entryCount];
        Arrays.fill(this.model, ' ');
        this.entryCount = entryCount;
        this.singleSize = size;
    }

    public void insert(int entryIndex, int offset, int length, String value, Alignment alignment) {
        int entryOffset = this.singleSize * entryIndex + offset;
        if (entryIndex >= this.entryCount) {
            throw new IllegalArgumentException("EntryIndex greater than entryCount");
        }
        if (length < value.length()) {
            this.logger.warning(String.format("Value %s have more signs than maximum %d", value, length));
            value = value.substring(0, length);
        }
        if (offset - 1 + length > this.singleSize) {
            throw new IllegalArgumentException("Offset out of bounds");
        }
        if (alignment.equals((Object)Alignment.RIGHT) && value.length() < length) {
            value = String.format("%" + length + "s", value);
        }
        if (alignment.equals((Object)Alignment.RIGHT_WITH_LEADING_ZEROS)) {
            value = String.format("%" + length + "s", value).replace(' ', '0');
        }
        System.arraycopy(value.toCharArray(), 0, this.model, entryOffset - 1, value.length());
    }

    public void insert(int entryIndex, int offset, int length, String value) {
        this.insert(entryIndex, offset, length, value, Alignment.LEFT);
    }

    public String buildString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.model.length; i += this.singleSize) {
            result.append(new String(this.model, i, this.singleSize));
            if (i + this.singleSize >= this.model.length) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public URL buildFile(String filepath) {
        URL uRL;
        if (!this.kfmDir.exists()) {
            this.kfmDir.mkdir();
        }
        File file = new File(this.kfmDir, filepath);
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(this.buildString());
            uRL = file.toURI().toURL();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return uRL;
    }
}

