/*
 * Decompiled with CFR 0.152.
 */
package com.rewoo.external.rest.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LdapAttributeNameFormatter {
    private static final Pattern ATTRIBUTE_NAME_PATTERN = Pattern.compile("(^|\\s)([a-zA-Z]([a-zA-Z]|[0-9])*)");
    private String formatString;
    private List<String> attributeNames;

    public LdapAttributeNameFormatter(String formatString) {
        this.formatString = formatString;
        this.attributeNames = null;
    }

    public List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.detectAttributeNames();
        }
        return this.attributeNames;
    }

    public String format(Map<String, String> values) {
        StringBuilder output = new StringBuilder(this.formatString.length());
        StringBuilder currentAttribute = new StringBuilder();
        boolean withinAttribute = false;
        for (int i = 0; i < this.formatString.length(); ++i) {
            char currentChar = this.formatString.charAt(i);
            if (withinAttribute) {
                if (LdapAttributeNameFormatter.isAlphabetic(currentChar) || LdapAttributeNameFormatter.isDigit(currentChar)) {
                    currentAttribute.append(currentChar);
                    continue;
                }
                this.addAttributeValue(values, currentAttribute.toString(), output);
                currentAttribute = new StringBuilder();
                withinAttribute = false;
                output.append(currentChar);
                continue;
            }
            if (LdapAttributeNameFormatter.isAlphabetic(currentChar) && (i == 0 || Character.isWhitespace(this.formatString.charAt(i - 1)))) {
                currentAttribute.append(currentChar);
                withinAttribute = true;
                continue;
            }
            output.append(currentChar);
        }
        if (currentAttribute.length() > 0) {
            this.addAttributeValue(values, currentAttribute.toString(), output);
        }
        return output.toString();
    }

    private void addAttributeValue(Map<String, String> values, String currentAttribute, StringBuilder output) {
        String value = values.get(currentAttribute);
        if (value != null) {
            output.append(value);
        }
    }

    private static boolean isDigit(char aChar) {
        return aChar >= '0' && aChar <= '9';
    }

    private static boolean isAlphabetic(char aChar) {
        return aChar >= 'a' && aChar <= 'z' || aChar >= 'A' && aChar <= 'Z';
    }

    private void detectAttributeNames() {
        this.attributeNames = new ArrayList<String>();
        Matcher matcher = ATTRIBUTE_NAME_PATTERN.matcher(this.formatString);
        while (matcher.find()) {
            String attributeName = matcher.group(2);
            this.attributeNames.add(attributeName);
        }
    }
}

