/*
 * Decompiled with CFR 0.152.
 */
package com.rewoo.external.rest.model;

import com.rewoo.external.rest.model.EntryValueState;
import com.rewoo.external.rest.model.NullScopeValue;
import com.rewoo.external.rest.model.ScopeEntityType;
import com.rewoo.external.rest.model.ScopeNumber;
import com.rewoo.external.rest.model.ScopeValue;
import com.rewoo.external.rest.model.TypedScopeEntity;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum ScopeEntryType {
    BOOLEAN("Boolean"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    }
    ,
    CONDITION("Condition"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return BOOLEAN.createValue(mapRepresentation);
        }
    }
    ,
    CHOICE("Choice"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    }
    ,
    MULTIPLE_CHOICE("MultipleChoice"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> {
                if (value == null || !(value instanceof List)) {
                    return null;
                }
                return (List)value;
            }, mapRepresentation);
        }
    }
    ,
    DATE("Date"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> {
                String dateAsString = (String)value;
                if (dateAsString == null) {
                    return null;
                }
                try {
                    return new Date(ZonedDateTime.parse(dateAsString).toInstant().toEpochMilli());
                }
                catch (DateTimeParseException e) {
                    throw new RuntimeException("Unable to parse date " + dateAsString);
                }
            }, mapRepresentation);
        }
    }
    ,
    ELEMENT_LINK("ElementLinks"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> {
                if (value == null || !(value instanceof List)) {
                    return null;
                }
                ArrayList<TypedScopeEntity> result = new ArrayList<TypedScopeEntity>();
                List elementLinks = (List)value;
                for (Map elementLink : elementLinks) {
                    result.add(new TypedScopeEntity(ScopeEntryType.getElementLinkId(elementLink), (String)elementLink.get("name"), ScopeEntityType.ELEMENT));
                }
                return result;
            }, mapRepresentation);
        }
    }
    ,
    FILE_LINKS("FileLinks"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> {
                if (value == null || !(value instanceof List)) {
                    return null;
                }
                ArrayList<TypedScopeEntity> result = new ArrayList<TypedScopeEntity>();
                List fileLinks = (List)value;
                for (Map fileLink : fileLinks) {
                    result.add(new TypedScopeEntity(Long.valueOf(fileLink.get("attachmentId").toString()), fileLink.get("filename").toString(), ScopeEntityType.ATTACHMENT));
                }
                return result;
            }, mapRepresentation);
        }
    }
    ,
    IMAGE("Image"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return FILE_LINKS.createValue(mapRepresentation);
        }
    }
    ,
    SPREADSHEET_FILE("SpreadsheetFile"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return FILE_LINKS.createValue(mapRepresentation);
        }
    }
    ,
    NUMBER("Number"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> {
                if (value == null || !(value instanceof Map)) {
                    return null;
                }
                Map numberParams = (Map)value;
                return new ScopeNumber((BigDecimal)numberParams.get("value"), (String)numberParams.get("unit"));
            }, mapRepresentation);
        }
    }
    ,
    RICHTEXT("RichText"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    }
    ,
    STRING("String"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    }
    ,
    EMAIL_LINK("Email"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    }
    ,
    EXTERNAL_LINK("ExternalLinks"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    }
    ,
    UNSUPPORTED("Unsupported"){

        @Override
        public ScopeValue createValue(Map<String, Object> mapRepresentation) {
            return this.createValue(value -> value, mapRepresentation);
        }
    };

    private static final Logger logger;
    private static final Map<String, Date> dateCache;
    private String title;

    public static ScopeEntryType getTypeFor(String name) {
        name = name.toUpperCase();
        for (ScopeEntryType type : ScopeEntryType.values()) {
            String normalized = type.title.toUpperCase();
            if (!normalized.equals(name)) continue;
            return type;
        }
        logger.info("Unknown entry type " + name + " found. Map entry type to UNSUPPORTED");
        return UNSUPPORTED;
    }

    public static void forceCacheInvalidation() {
        dateCache.clear();
    }

    public abstract ScopeValue createValue(Map<String, Object> var1);

    public String getTitle() {
        return this.title;
    }

    private ScopeEntryType(String title) {
        this.title = title;
    }

    private static Long getElementLinkId(Map<String, Object> elementLinkAttrs) {
        Long connectionId = Long.valueOf(elementLinkAttrs.get("connectionId").toString());
        if (connectionId != 0L) {
            return connectionId;
        }
        Long nodeId = Long.valueOf(elementLinkAttrs.get("nodeId").toString());
        if (nodeId != 0L) {
            return nodeId;
        }
        Long aspectId = Long.valueOf(elementLinkAttrs.get("aspectId").toString());
        if (aspectId != 0L) {
            return aspectId;
        }
        return Long.valueOf(elementLinkAttrs.get("objectId").toString());
    }

    protected ScopeValue createValue(Function<Object, Object> valueParser, Map<String, Object> mapRepresentation) {
        String timestampAsString = (String)mapRepresentation.get("timestamp");
        Date timestamp = dateCache.get(timestampAsString);
        if (timestamp == null) {
            try {
                timestamp = new Date(ZonedDateTime.parse((String)mapRepresentation.get("timestamp")).toInstant().toEpochMilli());
                dateCache.putIfAbsent(timestampAsString, timestamp);
            }
            catch (DateTimeParseException e) {
                logger.warn("Can not parse timestamp " + String.valueOf(mapRepresentation.get("timestamp")) + " for entry id " + String.valueOf(mapRepresentation.get("entryId")) + ". Using  null instead!", (Throwable)e);
            }
        }
        Long entryId = Long.valueOf(mapRepresentation.get("entryId").toString());
        EntryValueState valueState = EntryValueState.valueOf((String)mapRepresentation.get("state"));
        Boolean isFormula = (Boolean)mapRepresentation.get("isFormula");
        Object value = valueParser.apply(mapRepresentation.get("value"));
        if (value == null) {
            return new NullScopeValue(entryId, timestamp);
        }
        return new ScopeValue(entryId, value, valueState, isFormula, timestamp);
    }

    static {
        logger = LogManager.getLogger(ScopeEntryType.class);
        dateCache = new ConcurrentHashMap<String, Date>();
    }
}

