﻿using NLog;
using NLog.Config;
using NLog.Targets;

namespace BoFilTest.Utils
{
    class Logging
    {
        public static void Configure()
        {
            var config = new LoggingConfiguration();

            var fileTarget = new FileTarget();
            config.AddTarget("application-log-file", fileTarget);

            fileTarget.FileName = "${basedir}/Logs/application-log-${shortdate}.log";
            fileTarget.Layout = "${longdate} ${uppercase:${level}} ${message} ${exception:format=tostring}";

            var consoleTarget = new ColoredConsoleTarget
            {
                Layout = fileTarget.Layout
            };

            config.AddTarget("developer-console", consoleTarget);

            var rule = new LoggingRule("*", LogLevel.Info, fileTarget);
            rule.Targets.Add(consoleTarget);
            config.LoggingRules.Add(rule);

            LogManager.Configuration = config;
        }
    }
}
