﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;

namespace BoFilTest.Utils
{
    class AllTextBlocks
    {
        public static List<TextBlock> ForRoot(DependencyObject root)
        {
            var result = new List<TextBlock>();

            foreach (var child in LogicalTreeHelper.GetChildren(root))
            {
                // Recurse?
                var nextRoot = child as DependencyObject;
                if (nextRoot != null)
                {
                    result.AddRange(ForRoot(nextRoot));
                }

                var textBlock = child as TextBlock;
                if (textBlock == null)
                {
                    continue;
                }

                // Ignore TextBlocks that have a data binding
                var bindingExpression = BindingOperations.GetBindingExpression(textBlock, TextBlock.TextProperty);
                if (bindingExpression != null)
                {
                    continue;
                }

                result.Add(textBlock);
            }
            return result;
        }

        public static void TranslateForRoot(DependencyObject root)
        {
            foreach (var component in AllTextBlocks.ForRoot(root))
            {
                var translated = Translated.FromKey(component.Text);
                var parts = translated.Split(new string[]{ @"\n"}, StringSplitOptions.None);
                if (parts.Length==1)
                {
                    component.Text = translated;
                    continue;
                }
                component.Inlines.Clear();
                component.Inlines.Add(parts[0]);
                for (int i=1; i<parts.Length; ++i)
                {
                    component.Inlines.Add(new LineBreak());
                    component.Inlines.Add(parts[1]);
                }
            }
        }
    }
}

