﻿using BoFilTest.Domain;
using BoFilTest.Utils;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using Unity;

namespace BoFilTest.UI
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private readonly IUnityContainer container;
        private readonly EventBus eventBus;

        public MainWindow(IUnityContainer container, EventBus eventBus, DataModel dataModel)
        {
            this.container = container;
            this.eventBus = eventBus;
            InitializeComponent();

            // Show application version
            if (dataModel.Version != "")
            {
                this.Title = Translated.FromKey("APPLICATION_TITLE", dataModel.Version);
            }

            Loaded += MainWindow_Loaded;
        }

        private void MainWindow_Loaded(object sender, RoutedEventArgs e)
        {
            Frame.NavigationService.Navigate(container.Resolve<StartPage>());
        }

        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            this.eventBus.Publish(new KeyPressed());
        }
    }
}
