﻿
using System;
using System.Collections.Generic;

namespace BoFilTest.Domain
{
    class StepChanged
    {
        public StepChanged(TestStep step, List<TestStep> all)
        {
            Step = step;
            All = all;
        }

        public TestStep Step { get; }
        public List<TestStep> All { get; }
    }

    class TestStarted
    {
        public TestStarted(DateTime time, MeasuredValues values, int calibrationCurveIndex)
        {
            Time = time;
            Values = values;
            CalibrationCurveIndex = calibrationCurveIndex;
        }

        public DateTime Time { get; }
        public MeasuredValues Values { get; }
        public int CalibrationCurveIndex { get; }
    }

    class TestFinished
    {
        public TestFinished(TestTimings timings, List<TestStep> all, float? gasIntegral)
        {
            Timings = timings;
            All = all;
            GasIntegral = gasIntegral;
        }

        public TestTimings Timings { get; }
        public List<TestStep> All { get; }
        public float? GasIntegral { get; }
    }

    class TimeoutHit
    {

    }

    class TimeDisplay
    {
        public TimeDisplay(string text, bool warn)
        {
            Text = text;
            Warn = warn;
        }

        public string Text { get; }
        public bool Warn { get; }

        public override bool Equals(object obj)
        {
            var display = obj as TimeDisplay;
            return display != null &&
                   Text == display.Text &&
                   Warn == display.Warn;
        }

        public override int GetHashCode()
        {
            var hashCode = 1377999391;
            hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(Text);
            hashCode = hashCode * -1521134295 + Warn.GetHashCode();
            return hashCode;
        }
    }

    class NewValues
    {
        public NewValues(StepDescription step, DateTime time, MeasuredValues values)
        {
            Step = step;
            Time = time;
            Values = values;
        }

        public StepDescription Step { get; }
        public DateTime Time { get; }
        public MeasuredValues Values { get; }
    }

    class NewValuesWithTare
    {
        public NewValuesWithTare(StepDescription step, MeasuredValues values)
        {
            Step = step;
            Values = values;
        }

        public StepDescription Step { get; }
        public MeasuredValues Values { get; }
    }

    class KeyPressed
    {

    }
}
