﻿using Optional;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace BoFilTest.Domain.Modules
{
    class YoctopucePressureMeasure : IPressureMeasure
    {
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();
        private readonly YSensor sensor;

        public YoctopucePressureMeasure(string DeviceName)
        {
            logger.Info("Starting Yoctopuce pressure measure with device name {0}", DeviceName);

            YoctupuceCapability.Acquire();

            this.sensor = YSensor.FindSensor(DeviceName);
            if (this.sensor == null)
            {
                throw new HardwareException("Did not find sensor: " + DeviceName);
            }
        }

        public void Cleanup()
        {
            logger.Info("Stopping Yoctopuce pressure measure.");
            YoctupuceCapability.Release();
        }

        public Option<Pressure> ReadValue()
        {
            double value = this.sensor.get_currentValue();
            return Option.Some(new Pressure(value));
        }
    }
}
