﻿using System;
using Optional;

namespace BoFilTest.Domain.Modules
{
    class VoegtlinPressureMeasure : IPressureMeasure
    {
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();
        private readonly VoegtlinDevice device;

        public VoegtlinPressureMeasure(VoegtlinDevice device)
        {
            this.device = device;
        }

        public void Cleanup()
        {
        }

        public Option<Pressure> ReadValue()
        {
            try
            {
                return Option.Some(new Pressure(device.ReadPressure()));
            }
            catch (Exception e)
            {
                logger.Error(e, "Unable to read voegtlin pressure value");
                return Option.None<Pressure>();
            }
        }
    }
}
