﻿using BoFilTest.Utils;
using Optional;
using System;

namespace BoFilTest.Domain.Modules
{
    class EmulatedPressureMeasure : IPressureMeasure
    {
        private readonly SecondTimer Timer;
        public EmulatedPressureMeasure()
        {
            this.Timer = new SecondTimer();
        }

        public void Cleanup()
        {
            // Nothing to do
        }

        public Option<Pressure> ReadValue()
        {
            var s = Math.Sin(Timer.Get() / 5.0 * 2.0 * Math.PI);
            return Option.Some(new Pressure(s * s));
        }
    }
}
